/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities;

import com.google.common.collect.Maps;
import com.pikachu.mod.illager_more.CombatEvent;
import com.pikachu.mod.illager_more.entities.NewSamuraiEntity;
import com.pikachu.mod.illager_more.entities.ai.AvoidAndApproachTargetGoal;
import com.pikachu.mod.illager_more.entities.effects.AttackEffects;
import com.pikachu.mod.illager_more.init.ModEntityTypes;
import com.pikachu.mod.illager_more.init.ModItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SamuraiEntity
extends AbstractIllager
implements IAnimatable {
    public static final UUID SPEED_MODIFIER_RUNNING_UUID = UUID.fromString("05cd373b-0ff1-4ded-8630-b380232ed7b1");
    public static final AttributeModifier SPEED_MODIFIER_RUN = new AttributeModifier(SPEED_MODIFIER_RUNNING_UUID, "Running speed increase", 0.1, AttributeModifier.Operation.ADDITION);
    public static final EntityDataAccessor<Boolean> IS_PULLED_OUT_WEAPON = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_PULLING_OUT_WEAPON = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_WITHDRAW_WEAPON = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CAN_MELEE = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_MELEE = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_MELEE_FAST = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DESTROY_PROJECTILES = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DODGE = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_PARRY = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_BLOCK = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DASH = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_RUN = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> PARRY_TICK = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DODGE_TICK = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DASH_TICK = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BLOCK_TICK = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> PARRY_COOLDOWN = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DODGE_COOLDOWN = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MELEE_COOLDOWN = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DESTROY_PROJECTILES_COOLDOWN = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DASH_COOLDOWN = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BLOCK_COOLDOWN = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MELEE_TYPE = SynchedEntityData.m_135353_(SamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int timer = 0;
    protected int noDamagesTimer = 0;
    protected int MemoryTimeAfterTargetDisappears;
    protected List<Projectile> reboundedProjectiles;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public SamuraiEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 15;
        this.MemoryTimeAfterTargetDisappears = 0;
        this.reboundedProjectiles = new ArrayList<Projectile>();
    }

    protected void m_7472_(DamageSource p_21385_, int p_21386_, boolean p_21387_) {
        for (int i = this.m_217043_().m_188503_(2); i < 2; ++i) {
            this.m_19983_(new ItemStack((ItemLike)Items.f_42616_));
        }
        super.m_7472_(p_21385_, p_21386_, p_21387_);
    }

    protected boolean isElitesSamurai() {
        return false;
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        return AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public List<Projectile> getReboundedProjectiles() {
        return this.reboundedProjectiles;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        this.populateDefaultEquipmentSlots(p_37857_);
        this.m_213946_(this.f_19796_, p_37857_);
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    protected void populateDefaultEquipmentSlots(@Nonnull DifficultyInstance p_180481_1_) {
        if (this.m_37885_() == null) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.KATANA.get()));
        }
        if (this.m_217043_().m_188503_(88 - 28 * p_180481_1_.m_19048_().m_19028_()) == 0) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.SAMURAI_HELMET.get()));
            this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.SAMURAI_CHESTPLATE.get()));
            this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.SAMURAI_LEGGINGS.get()));
            this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.SAMURAI_BOOTS.get()));
            this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) * 1.5);
            this.m_21051_(Attributes.f_22281_).m_22100_(this.m_21172_(Attributes.f_22281_) * 1.5);
            this.m_21153_((float)this.m_21133_(Attributes.f_22276_));
            if (this.m_37885_() == null) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.KATANA.get()));
            }
        } else {
            this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.SAMURAI_ROBES.get()));
            this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.SAMURAI_PANTS.get()));
            this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.SAMURAI_SHOES.get()));
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.registerAttackGoal();
    }

    protected void registerAttackGoal() {
        this.f_21345_.m_25352_(0, (Goal)new DoHurtTargetGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DestroyProjectileGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PullOutWeaponGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BlockGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new WithdrawWeaponGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DodgeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DashGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SamuraiAvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 6.5f, 1.2, 0.65, true));
        this.f_21345_.m_25352_(5, (Goal)new SamuraiAttackGoal(this, 1.2, true));
        this.f_21345_.m_25352_(6, (Goal)new SamuraiGoal(this));
    }

    public void m_8107_() {
        AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
        if ((Integer)this.f_19804_.m_135370_(PARRY_TICK) > 0) {
            this.m_21573_().m_26573_();
        }
        if (this.m_5448_() != null) {
            this.MemoryTimeAfterTargetDisappears = this.f_19797_ + 60;
            if (this.m_20270_((Entity)this.m_5448_()) >= 9.0f) {
                if (!modifiableattributeinstance.m_22109_(SPEED_MODIFIER_RUN)) {
                    modifiableattributeinstance.m_22118_(SPEED_MODIFIER_RUN);
                }
            } else {
                modifiableattributeinstance.m_22120_(SPEED_MODIFIER_RUNNING_UUID);
            }
        } else if (this.m_37885_() != null) {
            if (!modifiableattributeinstance.m_22109_(SPEED_MODIFIER_RUN)) {
                modifiableattributeinstance.m_22118_(SPEED_MODIFIER_RUN);
            }
        } else {
            modifiableattributeinstance.m_22120_(SPEED_MODIFIER_RUNNING_UUID);
        }
        LivingEntity entity = this.m_5448_();
        for (SamuraiEntity samurai : this.f_19853_.m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82400_(20.0))) {
            if (entity == null || !samurai.m_21574_().m_148306_((Entity)entity) || !samurai.m_7307_((Entity)this) || samurai == this || samurai.m_5448_() != null && (samurai.m_5448_() == null || samurai.m_5448_().m_6084_())) continue;
            samurai.m_6710_(entity);
        }
        this.f_19804_.m_135381_(IS_RUN, (Object)modifiableattributeinstance.m_22109_(SPEED_MODIFIER_RUN));
        super.m_8107_();
        this.CooldownReduction();
        this.TickReduction();
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        this.f_19804_.m_135381_(PARRY_TICK, (Object)0);
        if (p_70097_1_.m_19360_() && ((Boolean)this.f_19804_.m_135370_(IS_DESTROY_PROJECTILES)).booleanValue()) {
            if (p_70097_1_.m_7640_() != null) {
                p_70097_1_.m_7640_().m_146870_();
            }
            return false;
        }
        if (!p_70097_1_.m_19376_() && !p_70097_1_.m_19360_()) {
            if (!p_70097_1_.m_19376_() && !((Boolean)this.f_19804_.m_135370_(IS_MELEE)).booleanValue()) {
                if (!this.m_20096_()) {
                    if (((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue()) {
                        return false;
                    }
                    if (((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue()) {
                        return false;
                    }
                }
                if ((Integer)this.f_19804_.m_135370_(PARRY_TICK) > 0 && !((Boolean)this.f_19804_.m_135370_(IS_BLOCK)).booleanValue()) {
                    return false;
                }
                boolean b = false;
                if (p_70097_1_.m_7639_() != null) {
                    b = this.m_21574_().m_148306_(p_70097_1_.m_7639_());
                }
                if (((Boolean)this.f_19804_.m_135370_(IS_BLOCK)).booleanValue() && b) {
                    this.f_19804_.m_135381_(CAN_MELEE, (Object)this.m_217043_().m_188499_());
                    this.f_19804_.m_135381_(PARRY_TICK, (Object)15);
                    this.noDamagesTimer = 68;
                    this.m_5496_(SoundEvents.f_12600_, 1.0f, 1.65f);
                    if ((this.m_5448_() == null || this.m_5448_() != null && !this.m_5448_().m_6084_()) && p_70097_1_.m_7639_() instanceof LivingEntity && this.m_6779_((LivingEntity)p_70097_1_.m_7639_())) {
                        this.m_6710_((LivingEntity)p_70097_1_.m_7639_());
                    }
                    return false;
                }
                for (Entity entityHit : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82377_(4.0, 4.0, 4.0))) {
                    float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                    float entityAttackingAngle = this.f_20883_ % 360.0f;
                    if (entityHitAngle < 0.0f) {
                        entityHitAngle += 360.0f;
                    }
                    if (entityAttackingAngle < 0.0f) {
                        entityAttackingAngle += 360.0f;
                    }
                    float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                    float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
                    if (!(entityHitDistance <= 4.0f && (double)entityRelativeAngle <= 65.0 && (double)entityRelativeAngle >= -65.0 || (double)entityRelativeAngle >= 295.0) && !((double)entityRelativeAngle <= -295.0) || p_70097_1_.m_7640_() != entityHit) continue;
                    b = true;
                    break;
                }
                if ((Integer)this.f_19804_.m_135370_(PARRY_COOLDOWN) <= 0 && b) {
                    this.f_19804_.m_135381_(PARRY_TICK, (Object)15);
                    this.f_19804_.m_135381_(PARRY_COOLDOWN, (Object)45);
                    this.noDamagesTimer = 32;
                    this.m_21573_().m_26573_();
                    this.m_5496_(SoundEvents.f_12600_, 1.0f, 1.5f);
                    if ((this.m_5448_() == null || this.m_5448_() != null && !this.m_5448_().m_6084_()) && p_70097_1_.m_7639_() instanceof LivingEntity && this.m_6779_((LivingEntity)p_70097_1_.m_7639_())) {
                        this.m_6710_((LivingEntity)p_70097_1_.m_7639_());
                    }
                    return false;
                }
            }
            if (this.noDamagesTimer > 0 && !(p_70097_1_.m_7640_() instanceof Player) && p_70097_1_.m_7640_() != this.m_21188_() && this.m_217043_().m_188499_()) {
                if ((this.m_5448_() == null || this.m_5448_() != null && !this.m_5448_().m_6084_()) && p_70097_1_.m_7639_() instanceof LivingEntity && this.m_6779_((LivingEntity)p_70097_1_.m_7639_())) {
                    this.m_6710_((LivingEntity)p_70097_1_.m_7639_());
                }
                return false;
            }
            if (this.isElitesSamurai() && ((Boolean)this.f_19804_.m_135370_(IS_MELEE)).booleanValue()) {
                this.m_5496_(SoundEvents.f_12600_, 1.0f, 1.5f);
                if ((this.m_5448_() == null || this.m_5448_() != null && !this.m_5448_().m_6084_()) && p_70097_1_.m_7639_() instanceof LivingEntity && this.m_6779_((LivingEntity)p_70097_1_.m_7639_())) {
                    this.m_6710_((LivingEntity)p_70097_1_.m_7639_());
                }
                return false;
            }
        }
        return super.m_6469_(p_70097_1_, p_70097_2_);
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
        boolean applyEnchant;
        ItemStack katana = new ItemStack((ItemLike)ModItems.KATANA.get());
        Raid raid = this.m_37885_();
        int enchantmentLevel = 2;
        if (raid != null && p_213660_1_ > raid.m_37724_(Difficulty.NORMAL)) {
            enchantmentLevel = 3;
        }
        if (raid == null) {
            this.m_8061_(EquipmentSlot.MAINHAND, katana);
            return;
        }
        boolean bl = applyEnchant = this.f_19796_.m_188501_() <= raid.m_37783_();
        if (applyEnchant) {
            HashMap enchantmentIntegerMap = Maps.newHashMap();
            enchantmentIntegerMap.put(Enchantments.f_44977_, enchantmentLevel);
            EnchantmentHelper.m_44865_((Map)enchantmentIntegerMap, (ItemStack)katana);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, katana);
        this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) * 1.35);
        this.m_21051_(Attributes.f_22281_).m_22100_(this.m_21172_(Attributes.f_22281_) * 1.35);
        this.m_21153_((float)this.m_21133_(Attributes.f_22276_));
    }

    public static void DestroyProjectiles(@Nonnull SamuraiEntity samuraiEntity, float range, float X, float Y, float Z, float arc) {
        boolean b = false;
        for (Projectile projectile : samuraiEntity.f_19853_.m_45976_(Projectile.class, samuraiEntity.m_20191_().m_82377_((double)X, (double)Y, (double)Z))) {
            float entityHitAngle = (float)((Math.atan2(projectile.m_20189_() - samuraiEntity.m_20189_(), projectile.m_20185_() - samuraiEntity.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = samuraiEntity.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((projectile.m_20189_() - samuraiEntity.m_20189_()) * (projectile.m_20189_() - samuraiEntity.m_20189_()) + (projectile.m_20185_() - samuraiEntity.m_20185_()) * (projectile.m_20185_() - samuraiEntity.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f)) continue;
            if (samuraiEntity.reboundedProjectiles.contains(projectile)) {
                return;
            }
            Projectile newProjectile = (Projectile)projectile.m_6095_().m_20615_(samuraiEntity.f_19853_);
            UUID uuid = newProjectile.m_20148_();
            newProjectile.m_20084_(uuid);
            projectile.m_5602_(null);
            newProjectile.m_5602_(null);
            newProjectile.m_20256_(projectile.m_20184_().m_82542_(-2.0, 1.0, -2.0));
            newProjectile.m_20219_(projectile.m_20182_());
            if (newProjectile instanceof AbstractHurtingProjectile) {
                AbstractHurtingProjectile newDamagingProjectile = (AbstractHurtingProjectile)newProjectile;
                Vec3 newPower = newProjectile.m_20184_();
                newDamagingProjectile.f_36813_ = newPower.m_7096_();
                newDamagingProjectile.f_36814_ = newPower.m_7098_();
                newDamagingProjectile.f_36815_ = newPower.m_7094_();
            }
            if (newProjectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)newProjectile;
                arrow.m_36781_(arrow.m_36789_() + 3.0);
                arrow.m_5602_((Entity)samuraiEntity);
            }
            projectile.m_146870_();
            samuraiEntity.f_19853_.m_7967_((Entity)newProjectile);
            samuraiEntity.reboundedProjectiles.add(newProjectile);
            b = true;
        }
        if (b) {
            samuraiEntity.m_5496_(SoundEvents.f_12600_, 1.0f, 1.5f);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.265f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 2.5);
    }

    @Nonnull
    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource p_184601_1_) {
        return SoundEvents.f_12579_;
    }

    protected void m_7355_(@Nonnull BlockPos p_180429_1_, @Nonnull BlockState p_180429_2_) {
        if (this.m_6844_(EquipmentSlot.HEAD).m_41720_().equals(ModItems.SAMURAI_HELMET.get()) && this.m_6844_(EquipmentSlot.CHEST).m_41720_().equals(ModItems.SAMURAI_CHESTPLATE.get()) && this.m_6844_(EquipmentSlot.LEGS).m_41720_().equals(ModItems.SAMURAI_LEGGINGS.get()) && this.m_6844_(EquipmentSlot.FEET).m_41720_().equals(ModItems.SAMURAI_BOOTS.get())) {
            this.m_5496_(SoundEvents.f_11676_, 0.75f, 1.0f);
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().animationSpeed = 1.0;
        SamuraiEntity livingEntity = this;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if ((Integer)this.f_19804_.m_135370_(PARRY_TICK) > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("parry", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_PULLING_OUT_WEAPON)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("pull_out_weapon", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_WITHDRAW_WEAPON)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("withdraw_weapon", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_MELEE)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 1 || (Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 5 ? "melee_attack_type_1" : ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 2 ? "melee_attack_type_2" : ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 3 ? "melee_attack_type_3" : ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 4 ? "melee_attack_type_4" : "skill"))), Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dodge", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dash", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_BLOCK)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("block", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DESTROY_PROJECTILES)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("destroy_projectile", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed(Math.max((double)(groundSpeed * 20.0f), 0.15));
            if (!((Boolean)this.f_19804_.m_135370_(IS_RUN)).booleanValue()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false ? "walk_pulled_out_weapon" : "walk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("run", Boolean.valueOf(true)));
            }
        } else if (this.m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("celebrate", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false ? "idle_pulled_out_weapon" : "idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAN_MELEE, (Object)false);
        this.f_19804_.m_135372_(IS_MELEE, (Object)false);
        this.f_19804_.m_135372_(IS_MELEE_FAST, (Object)false);
        this.f_19804_.m_135372_(IS_DASH, (Object)false);
        this.f_19804_.m_135372_(IS_BLOCK, (Object)false);
        this.f_19804_.m_135372_(IS_DODGE, (Object)false);
        this.f_19804_.m_135372_(IS_PARRY, (Object)false);
        this.f_19804_.m_135372_(IS_RUN, (Object)false);
        this.f_19804_.m_135372_(IS_DESTROY_PROJECTILES, (Object)false);
        this.f_19804_.m_135372_(IS_PULLED_OUT_WEAPON, (Object)false);
        this.f_19804_.m_135372_(IS_PULLING_OUT_WEAPON, (Object)false);
        this.f_19804_.m_135372_(IS_WITHDRAW_WEAPON, (Object)false);
        this.f_19804_.m_135372_(DASH_TICK, (Object)0);
        this.f_19804_.m_135372_(DODGE_TICK, (Object)0);
        this.f_19804_.m_135372_(PARRY_TICK, (Object)0);
        this.f_19804_.m_135372_(BLOCK_TICK, (Object)0);
        this.f_19804_.m_135372_(DASH_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(PARRY_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(DODGE_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(MELEE_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(BLOCK_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(DESTROY_PROJECTILES_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(MELEE_TYPE, (Object)0);
    }

    protected void CooldownReduction() {
        if ((Integer)this.f_19804_.m_135370_(DASH_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(DASH_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(DASH_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(PARRY_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(PARRY_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(PARRY_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DODGE_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(DODGE_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(DODGE_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(MELEE_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(MELEE_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(MELEE_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(BLOCK_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(BLOCK_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(BLOCK_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DESTROY_PROJECTILES_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(DESTROY_PROJECTILES_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(DESTROY_PROJECTILES_COOLDOWN) - 1));
        }
    }

    protected void TickReduction() {
        if (this.noDamagesTimer > 0) {
            --this.noDamagesTimer;
        }
        if ((Integer)this.f_19804_.m_135370_(DASH_TICK) > 0) {
            this.f_19804_.m_135381_(DASH_TICK, (Object)((Integer)this.f_19804_.m_135370_(DASH_TICK) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(PARRY_TICK) > 0) {
            this.f_19804_.m_135381_(PARRY_TICK, (Object)((Integer)this.f_19804_.m_135370_(PARRY_TICK) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DODGE_TICK) > 0) {
            this.f_19804_.m_135381_(DODGE_TICK, (Object)((Integer)this.f_19804_.m_135370_(DODGE_TICK) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(BLOCK_TICK) > 0) {
            this.f_19804_.m_135381_(BLOCK_TICK, (Object)((Integer)this.f_19804_.m_135370_(BLOCK_TICK) - 1));
        }
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_7307_(Entity p_33314_) {
        if (super.m_7307_(p_33314_)) {
            return true;
        }
        if (p_33314_ instanceof LivingEntity && ((LivingEntity)p_33314_).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && p_33314_.m_5647_() == null;
        }
        return false;
    }

    public boolean m_37882_() {
        return super.m_37882_() && this.m_5647_() == null;
    }

    static class DoHurtTargetGoal
    extends Goal {
        protected final SamuraiEntity mob;
        protected int type;
        protected static final int horizontalChop = 1;
        protected static final int chopFromBottomUp = 2;
        protected static final int obliqueChop = 3;
        protected static final int verticalChop = 4;
        protected static final int blockAndChop = 5;
        protected boolean canMoving;
        protected boolean hasNext;

        public DoHurtTargetGoal(SamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (Boolean)this.mob.f_19804_.m_135370_(CAN_MELEE) != false && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false;
        }

        public boolean m_8045_() {
            if (!this.hasNext) {
                return this.isAttacking() && this.mob.m_5448_() != null;
            }
            if (!this.isAttacking()) {
                this.mob.timer = 0;
                this.mob.noDamagesTimer = 2;
                ++this.type;
                if (this.mob.isElitesSamurai()) {
                    return this.mob.m_5448_() != null;
                }
                return this.mob.m_217043_().m_188499_() && this.mob.m_5448_() != null && (this.mob.m_5448_().f_20916_ > 0 || this.mob.f_19796_.m_188501_() <= 0.35f || this.mob.m_5448_() instanceof SamuraiEntity || this.mob.m_5448_() instanceof NewSamuraiEntity);
            }
            return true;
        }

        private boolean isAttacking() {
            return this.mob.timer < (this.type == 1 ? 3 : (this.type == 2 ? 5 : (this.type == 3 ? 3 : (this.type == 4 ? 4 : (this.type == 5 ? 3 : 20))))) + 1 - this.mob.m_217043_().m_188503_(3);
        }

        public boolean m_6767_() {
            if (!this.mob.isElitesSamurai() || !((double)this.mob.m_21223_() >= (double)this.mob.m_21233_() / 1.3)) {
                return this.mob.f_20916_ > 0 && this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) < 6.0f;
            }
            return this.mob.m_5448_() != null;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.type = 1;
            this.mob.f_19804_.m_135381_(IS_MELEE, (Object)true);
            this.mob.f_19804_.m_135381_(CAN_MELEE, (Object)false);
            this.mob.f_19804_.m_135381_(MELEE_TYPE, (Object)1);
            if (this.mob.isElitesSamurai() && (double)this.mob.m_21223_() < (double)this.mob.m_21233_() / 1.3 && this.mob.m_5448_() != null) {
                this.mob.m_20256_(this.mob.m_20184_().m_82520_((this.mob.m_5448_().m_20185_() - this.mob.m_20185_()) / Math.PI, 0.0, (this.mob.m_5448_().m_20189_() - this.mob.m_20189_()) / Math.PI).m_82490_(2.8));
            }
        }

        public void m_8037_() {
            if (!this.mob.isElitesSamurai() || !((double)this.mob.m_21223_() >= (double)this.mob.m_21233_() / 1.3)) {
                ++this.mob.timer;
                this.mob.m_20334_(0.0, this.mob.m_20184_().f_82480_, 0.0);
                this.mob.f_19804_.m_135381_(PARRY_TICK, (Object)0);
                if (this.type == 1) {
                    this.attack(2);
                    this.hasNext = true;
                } else if (this.type == 2) {
                    this.attack(3);
                    this.hasNext = true;
                } else if (this.type == 3) {
                    this.attack(2);
                    this.hasNext = true;
                } else if (this.type == 4) {
                    this.attack(2);
                    this.hasNext = this.mob.m_217043_().m_188499_() || this.mob.m_217043_().m_188499_();
                } else if (this.type == 5) {
                    this.attack(2);
                    this.hasNext = false;
                }
                if (this.mob.m_5448_() == null) {
                    this.hasNext = false;
                }
                if (!this.canMoving) {
                    this.mob.m_21573_().m_26573_();
                }
                if (this.mob.m_5448_() != null) {
                    this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
                    if (this.canMoving) {
                        this.mob.m_21573_().m_5624_((Entity)this.mob.m_5448_(), 1.0);
                    }
                }
                this.mob.f_19804_.m_135381_(MELEE_TYPE, (Object)this.type);
            } else {
                this.mob.f_19804_.m_135381_(MELEE_TYPE, (Object)this.type);
                if (this.mob.m_5448_() != null) {
                    if (this.mob.timer <= 1 && this.type != 6) {
                        this.mob.m_20256_(this.mob.m_20184_().m_82520_((this.mob.m_5448_().m_20185_() - this.mob.m_20185_()) / Math.PI, 0.0, (this.mob.m_5448_().m_20189_() - this.mob.m_20189_()) / Math.PI).m_82542_(3.5 - this.mob.m_217043_().m_188500_(), 1.0, 3.5 - this.mob.m_217043_().m_188500_()));
                    } else if (this.mob.timer <= 1) {
                        this.mob.m_20256_(this.mob.m_20184_().m_82520_((this.mob.m_5448_().m_20185_() - this.mob.m_20185_()) / Math.PI, 6.65, (this.mob.m_5448_().m_20189_() - this.mob.m_20189_()) / Math.PI).m_82490_(0.24));
                    }
                }
                this.mob.noDamagesTimer = 2;
                this.mob.f_19804_.m_135381_(PARRY_TICK, (Object)0);
                if (this.type == 1) {
                    this.attack(2);
                    this.hasNext = true;
                } else if (this.type == 2) {
                    this.attack(3);
                    this.hasNext = true;
                } else if (this.type == 3) {
                    this.attack(2);
                    this.hasNext = true;
                } else if (this.type == 4) {
                    this.attack(2);
                    this.hasNext = true;
                } else if (this.type == 5) {
                    this.attack(2);
                    this.hasNext = true;
                } else {
                    if (this.mob.timer == 11) {
                        this.mob.m_20256_(this.mob.m_20184_().m_82520_((this.mob.m_5448_().m_20185_() - this.mob.m_20185_()) / Math.PI, -6.62, (this.mob.m_5448_().m_20189_() - this.mob.m_20189_()) / Math.PI).m_82490_(0.24));
                    }
                    this.attack(15);
                    this.mob.noDamagesTimer = 0;
                    this.hasNext = false;
                }
                ++this.mob.timer;
            }
        }

        private void attack(int i) {
            if (this.mob.timer == 1) {
                float rot = this.type == 1 ? -195.0f : (this.type == 2 ? -90.0f : (this.type == 3 ? 45.0f : (this.type == 4 ? 90.0f : -195.0f)));
                float f = (float)Mth.m_14136_((double)(this.mob.m_5448_().m_20189_() - this.mob.m_20189_()), (double)(this.mob.m_5448_().m_20185_() - this.mob.m_20185_()));
                AttackEffects e = AttackEffects.spawnAttackEffects((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 1, rot, 1.1f, 2.0f);
                e.m_20219_(CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.335, this.mob.f_20883_));
                e.setCaster((LivingEntity)this.mob);
                e.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 5.335, this.mob.f_20883_));
                e.m_146922_(-(e.m_146908_() % 360.0f) - 90.0f);
                this.mob.f_19853_.m_7967_((Entity)e);
            }
            if (!this.mob.isElitesSamurai()) {
                if (this.mob.timer == i) {
                    this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.2f);
                    CombatEvent.AreaAttack((LivingEntity)this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 170.0f, 0.833333f, 0.0, 1.0, false);
                    SamuraiEntity.DestroyProjectiles(this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 170.0f);
                    this.canMoving = false;
                }
            } else if (this.mob.timer == i) {
                float damage = this.mob.m_5448_() instanceof Player ? 0.8333f : (this.mob.m_5448_() != null ? Math.min(1.0f + this.mob.m_5448_().m_21233_() / 60.0f, 5.0f) : 1.2f);
                for (LivingEntity entityHit : this.mob.f_19853_.m_45976_(LivingEntity.class, this.mob.m_20191_().m_82400_(5.0))) {
                    if (this.mob.m_7307_((Entity)entityHit) || entityHit == this.mob) continue;
                    entityHit.f_19802_ = 0;
                    entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_) * damage);
                    float attackKnockback = (float)this.mob.m_21133_(Attributes.f_22282_);
                    double ratioX = Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                    double ratioZ = -Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                    entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), damage);
                    CombatEvent.forceKnockback(entityHit, attackKnockback * 0.8f, ratioX, ratioZ, 0.5);
                    entityHit.m_20256_(entityHit.m_20184_().m_82520_(0.0, 0.0, 0.0));
                }
                this.canMoving = false;
            }
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_MELEE, (Object)false);
            this.mob.f_19804_.m_135381_(MELEE_COOLDOWN, (Object)(this.mob.isElitesSamurai() ? 70 : 25));
        }
    }

    static class DestroyProjectileGoal
    extends Goal {
        private static final int attackTimerTakesEffect = 3;
        private static final int attackTimerEnd = 5;
        private final SamuraiEntity mob;

        public DestroyProjectileGoal(SamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            boolean b = false;
            for (Projectile entityHit : this.mob.f_19853_.m_45976_(Projectile.class, this.mob.m_20191_().m_82400_(10.0))) {
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.mob.m_20189_(), entityHit.m_20185_() - this.mob.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.mob.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                Vec3 velocity = entityHit.m_20184_();
                float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.mob.m_20189_()) * (entityHit.m_20189_() - this.mob.m_20189_()) + (entityHit.m_20185_() - this.mob.m_20185_()) * (entityHit.m_20185_() - this.mob.m_20185_()));
                if (!(entityHitDistance <= 5.5f + groundSpeed * groundSpeed * 2.0f && entityRelativeAngle <= 67.5f && entityRelativeAngle >= -67.5f || entityRelativeAngle >= 292.5f) && !(entityRelativeAngle <= -292.5f)) continue;
                if (this.mob.reboundedProjectiles.contains(entityHit)) break;
                if (entityHit.m_37282_() != null && entityHit.m_37282_().m_7307_((Entity)this.mob)) {
                    return false;
                }
                if (entityHit instanceof AbstractArrow) {
                    AbstractArrow arrow = (AbstractArrow)entityHit;
                    if (!arrow.f_36703_ && !arrow.f_19853_.m_45772_(new AABB(arrow.m_20182_(), arrow.m_20182_()).m_82400_(0.06))) {
                        if ((double)groundSpeed <= 0.15) {
                            return false;
                        }
                        b = true;
                        break;
                    }
                }
                if (entityHit instanceof AbstractHurtingProjectile) {
                    b = true;
                    break;
                }
                b = true;
                break;
            }
            return b && (Integer)this.mob.f_19804_.m_135370_(DESTROY_PROJECTILES_COOLDOWN) <= 0 && (Boolean)this.mob.f_19804_.m_135370_(IS_DASH) == false && (Boolean)this.mob.f_19804_.m_135370_(IS_DODGE) == false && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (Integer)this.mob.f_19804_.m_135370_(DESTROY_PROJECTILES_COOLDOWN) <= 0;
        }

        public boolean m_8045_() {
            return this.mob.timer < 5;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DESTROY_PROJECTILES, (Object)true);
            float rot = -195.0f;
            float f = (float)Mth.m_14136_((double)(this.mob.m_5448_().m_20189_() - this.mob.m_20189_()), (double)(this.mob.m_5448_().m_20185_() - this.mob.m_20185_()));
            AttackEffects e = AttackEffects.spawnAttackEffects((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 1, rot, 1.1f, 2.0f);
            e.m_20219_(CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.335, this.mob.f_20883_));
            e.setCaster((LivingEntity)this.mob);
            e.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 5.335, this.mob.f_20883_));
            e.m_146922_(-(e.m_146908_() % 360.0f) - 90.0f);
            this.mob.f_19853_.m_7967_((Entity)e);
        }

        public void m_8037_() {
            ++this.mob.timer;
            this.mob.m_21573_().m_26573_();
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
            if (this.mob.timer == 2) {
                this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.2f);
            }
            if (this.mob.timer <= 3) {
                CombatEvent.AreaAttack((LivingEntity)this.mob, 3.5f, 3.5f, 3.5f, 3.5f, 180.0f, 0.8f, 0.0, 0.5, false);
                SamuraiEntity.DestroyProjectiles(this.mob, 6.0f, 6.0f, 6.0f, 6.0f, 180.0f);
            }
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DESTROY_PROJECTILES, (Object)false);
            this.mob.f_19804_.m_135381_(DESTROY_PROJECTILES_COOLDOWN, (Object)10);
        }
    }

    static class PullOutWeaponGoal
    extends Goal {
        private final SamuraiEntity mob;

        public PullOutWeaponGoal(SamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) == false && (Boolean)this.mob.f_19804_.m_135370_(IS_RUN) == false;
        }

        public boolean m_6767_() {
            return this.mob.timer >= 10;
        }

        public boolean m_8045_() {
            return this.mob.timer < 20;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLING_OUT_WEAPON, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT_WEAPON, (Object)true);
            this.mob.f_19804_.m_135381_(IS_PULLING_OUT_WEAPON, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    static class BlockGoal
    extends Goal {
        private final SamuraiEntity mob;

        public BlockGoal(SamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && (Boolean)this.mob.f_19804_.m_135370_(IS_BLOCK) != false && (Integer)this.mob.f_19804_.m_135370_(BLOCK_COOLDOWN) <= 0 && this.mob.m_217043_().m_188499_() && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false;
        }

        public boolean m_6767_() {
            return (Boolean)this.mob.f_19804_.m_135370_(CAN_MELEE) != false || this.mob.m_217043_().m_188499_();
        }

        public boolean m_8045_() {
            return this.mob.timer < 50 && this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) < 12.0f && this.mob.f_20916_ <= 0;
        }

        public void m_8056_() {
            this.mob.timer = 0;
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_BLOCK, (Object)false);
            this.mob.f_19804_.m_135381_(BLOCK_COOLDOWN, (Object)300);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            this.mob.m_20334_(this.mob.m_20184_().f_82479_, 0.0, this.mob.m_20184_().f_82481_);
            if (this.mob.m_5448_() != null) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
            }
        }
    }

    static class WithdrawWeaponGoal
    extends Goal {
        private final SamuraiEntity mob;

        public WithdrawWeaponGoal(SamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_()) && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false && this.mob.MemoryTimeAfterTargetDisappears <= this.mob.f_19797_;
        }

        public boolean m_8045_() {
            return this.mob.timer < 20;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_WITHDRAW_WEAPON, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT_WEAPON, (Object)false);
            this.mob.f_19804_.m_135381_(IS_WITHDRAW_WEAPON, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    static class DodgeGoal
    extends Goal {
        private final SamuraiEntity mob;
        private static final int dodgeTimerTakesEffect = 6;
        private float dodgeYaw;

        public DodgeGoal(SamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return ((this.mob.m_20069_() || this.mob.m_20077_()) && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 12.0f || (Integer)this.mob.f_19804_.m_135370_(MELEE_COOLDOWN) > 0 && this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 7.0f || this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 13.0f && this.mob.f_20916_ > 0) && (Integer)this.mob.f_19804_.m_135370_(DODGE_COOLDOWN) <= 0 && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false && (!this.mob.isElitesSamurai() || (double)this.mob.m_21223_() >= (double)this.mob.m_21233_() / 1.5);
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return this.mob.timer < 8 || !this.mob.m_20096_() && !this.mob.m_20077_() && !this.mob.m_20069_();
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DODGE, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DODGE, (Object)false);
            this.mob.f_19804_.m_135381_(DODGE_COOLDOWN, (Object)30);
            this.mob.f_19804_.m_135381_(DASH_COOLDOWN, (Object)35);
            this.mob.f_19804_.m_135381_(DODGE_TICK, (Object)8);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
            if (this.mob.timer == 1) {
                this.dodgeYaw = (float)Math.toRadians(this.mob.f_20883_ % 360.0f + 90.0f + this.mob.m_217043_().m_188501_() * 150.0f - 75.0f);
            }
            if (this.mob.timer == 6 && (this.mob.m_20096_() || this.mob.m_20077_() || this.mob.m_20069_())) {
                float speed = -1.5f;
                Vec3 m = this.mob.m_20184_().m_82520_((double)speed * Math.cos(this.dodgeYaw), 0.0, (double)speed * Math.sin(this.dodgeYaw));
                this.mob.m_20334_(m.f_82479_, 0.6, m.f_82481_);
            }
        }
    }

    static class DashGoal
    extends Goal {
        private final SamuraiEntity mob;
        private static final int dodgeTimerTakesEffect = 6;

        public DashGoal(SamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 12.0f || this.mob.m_20077_() || this.mob.m_20069_()) && (Integer)this.mob.f_19804_.m_135370_(DASH_COOLDOWN) <= 0;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return this.mob.timer < 8 || !this.mob.m_20096_() && !this.mob.m_20077_() && !this.mob.m_20069_();
        }

        public void m_8056_() {
            this.mob.f_19804_.m_135381_(IS_DASH, (Object)true);
            this.mob.timer = 0;
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DASH, (Object)false);
            this.mob.f_19804_.m_135381_(DASH_COOLDOWN, (Object)30);
            this.mob.f_19804_.m_135381_(DASH_TICK, (Object)8);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
            if (this.mob.timer == 4 && (this.mob.m_20096_() || this.mob.m_20077_() || this.mob.m_20069_()) && this.mob.m_5448_() != null) {
                Vec3 m = this.mob.m_20184_().m_82520_(Math.max(Math.min(this.mob.m_5448_().m_20185_() - this.mob.m_20185_(), 1.7), -1.7), 0.0, Math.max(Math.min(this.mob.m_5448_().m_20189_() - this.mob.m_20189_(), 1.7), -1.7)).m_82490_(0.8);
                this.mob.m_20334_(m.f_82479_, 0.6, m.f_82481_);
            }
        }
    }

    class SamuraiAvoidEntityGoal
    extends AvoidAndApproachTargetGoal<LivingEntity> {
        public SamuraiAvoidEntityGoal(PathfinderMob enchanterIn, Class entityClassToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn, boolean followingTargetEvenIfNotSeen) {
            super(enchanterIn, entityClassToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn, followingTargetEvenIfNotSeen);
        }

        public boolean m_6767_() {
            return true;
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && (Integer)SamuraiEntity.this.f_19804_.m_135370_(MELEE_COOLDOWN) > 0;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && (Integer)SamuraiEntity.this.f_19804_.m_135370_(MELEE_COOLDOWN) > 0;
        }
    }

    static class SamuraiAttackGoal
    extends MeleeAttackGoal {
        protected final SamuraiEntity mobEntity;
        private int delayCounter;

        public SamuraiAttackGoal(SamuraiEntity p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            super((PathfinderMob)p_i1636_1_, p_i1636_2_, p_i1636_4_);
            this.mobEntity = p_i1636_1_;
        }

        public void m_8056_() {
            super.m_8056_();
            this.delayCounter = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.delayCounter = 0;
        }

        public void m_8037_() {
            if (this.mobEntity.m_5448_() == null) {
                return;
            }
            if (((Boolean)this.mobEntity.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON)).booleanValue()) {
                super.m_8037_();
                if ((Integer)this.mobEntity.f_19804_.m_135370_(MELEE_COOLDOWN) <= 0 && ((Boolean)this.mobEntity.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON)).booleanValue() && !this.mobEntity.isElitesSamurai() && this.mobEntity.m_20270_((Entity)this.mobEntity.m_5448_()) <= 20.0f && (Integer)this.mobEntity.f_19804_.m_135370_(BLOCK_COOLDOWN) <= 0 && this.mobEntity.m_217043_().m_188503_(50) == 0 && (!this.mobEntity.isElitesSamurai() || (double)this.f_25540_.m_21223_() >= (double)this.f_25540_.m_21233_() / 1.5) && this.mobEntity.m_20096_()) {
                    this.mobEntity.f_19804_.m_135381_(IS_BLOCK, (Object)true);
                }
            } else {
                this.mobEntity.f_21365_.m_24960_((Entity)this.mobEntity.m_5448_(), 30.0f, 30.0f);
                if (--this.delayCounter <= 0) {
                    this.delayCounter = 4 + this.mobEntity.m_217043_().m_188503_(7);
                    this.mobEntity.m_21573_().m_5624_((Entity)this.mobEntity.m_5448_(), 1.2);
                }
                this.m_6739_(this.mobEntity.m_5448_(), this.mobEntity.m_20275_(this.mobEntity.m_5448_().m_20185_(), this.mobEntity.m_5448_().m_20191_().f_82289_, this.mobEntity.m_5448_().m_20189_()));
            }
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d = distToEnemySqr + 20.0 + (double)enemy.m_20205_();
            int n = this.mobEntity.isElitesSamurai() && (double)this.f_25540_.m_21223_() >= (double)this.f_25540_.m_21233_() / 1.3 ? 120 : 0;
            if ((d + (double)n <= (double)this.mobEntity.m_20270_((Entity)enemy) || this.mobEntity.m_20191_().m_82381_(enemy.m_20191_().m_82400_(2.0)) || this.mobEntity.m_20191_().m_82381_(enemy.m_20191_().m_82377_(2.0, 2.0, 2.0))) && ((Boolean)this.mobEntity.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON)).booleanValue()) {
                this.mobEntity.f_19804_.m_135381_(CAN_MELEE, (Object)true);
            }
        }
    }

    static class SamuraiGoal
    extends Goal {
        protected final SamuraiEntity mobEntity;
        protected LivingEntity target;

        public SamuraiGoal(SamuraiEntity p_i1636_1_) {
            this.mobEntity = p_i1636_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.mobEntity.f_19853_.m_45976_(Player.class, this.mobEntity.m_20191_().m_82400_(32.0)).isEmpty() && (this.mobEntity.m_5448_() == null || this.mobEntity.m_5448_() != null && this.mobEntity.m_5448_().m_6084_()) && this.mobEntity.m_5647_() != null) {
                List players = this.mobEntity.f_19853_.m_45976_(Player.class, this.mobEntity.m_20191_().m_82400_(32.0));
                players.removeIf(player -> !this.mobEntity.m_7307_((Entity)player));
                this.target = players.isEmpty() ? null : (LivingEntity)players.get(this.mobEntity.m_217043_().m_188503_(players.size()));
            }
            return !this.mobEntity.f_19853_.m_45976_(Player.class, this.mobEntity.m_20191_().m_82400_(32.0)).isEmpty() && (this.mobEntity.m_5448_() == null || this.mobEntity.m_5448_() != null && !this.mobEntity.m_5448_().m_6084_()) && this.target != null;
        }

        public boolean m_8045_() {
            return !this.mobEntity.f_19853_.m_45976_(Player.class, this.mobEntity.m_20191_().m_82400_(32.0)).isEmpty() && (this.mobEntity.m_5448_() == null || this.mobEntity.m_5448_() != null && !this.mobEntity.m_5448_().m_6084_()) && this.target != null;
        }

        public void m_8037_() {
            if (this.target == null) {
                return;
            }
            if (this.target.m_20270_((Entity)this.target) <= 10.0f) {
                this.mobEntity.m_21573_().m_5624_((Entity)this.target, 0.98);
                this.mobEntity.m_21563_().m_148051_((Entity)this.target);
            } else {
                this.mobEntity.m_21573_().m_5624_((Entity)this.target, 1.35);
                this.mobEntity.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.target.m_21188_() != null && this.target.m_21188_().m_6084_()) {
                this.mobEntity.m_6710_(this.target.m_21188_());
            }
            if (this.target.m_21214_() != null && this.target.m_21214_().m_6084_()) {
                this.mobEntity.m_6710_(this.target.m_21214_());
            }
        }
    }
}

